//	CFileDos.h

#ifndef _H_CFileDos
#define _H_CFileDos

#include "DosStructs.h"
#include "CFile.h"

class CFileDos : public CFile {
	
	public:
	
	OSErr		IFileDos(
		CDiskDos			*cDisk, 
		CFolderDos			*cParentFolderDos, 
		Dos_SectorSpec		sector, 
		Dos_EntryIndex		diskLocDirEntryIndex,	//	relative to cur dir sector
		Dos_EntryIndex		directoryIndex			//	relative to entire directory
	);

	virtual	void		SetBinFileType(void);
	
	Dos_DirEntry		*GetMyEntry(void);
	
	virtual	ushort		GetLoadAddress(void);
	virtual	void		SetLoadAddress(ushort address);
	virtual	ulong		GetPhysicalSize(void);
	virtual	ulong		GetLogicalSize(void);
	virtual char		*GetDescription(char *buf);
	
	virtual	ushort		GetAuxType(void);
	virtual	void		SetAuxType(ushort auxType);

	virtual	void		SetName(char *buf);
	virtual	char		*GetName(char *buf);
	virtual	OSErr 		ReadFile(Byte *buffer, long length);
	virtual	OSErr 		WriteFile(Byte *buffer, long length);

	virtual	ulong		ADFS_GetBufSize(void);
	virtual	OSErr		ADFS_Read(ushort *bytesRead);
	virtual	OSErr		ADFS_Write(ushort *bytesWritten);
	virtual	OSErr		ADFS_Open(
		ADFS_IOType	ioType, 
		Boolean		resForkB, 
		char		**bufferP, 
		ulong		*bufSize);
		
	virtual	OSErr		ADFS_Close(void);

	void				Dos_UpdateBytesRead(
		ushort curSectorIndex, 
		ushort lastSectorIndex, 
		ushort *bytesRead);
	
	virtual	void		GetAccessBits(Gen_AccessBits *bits);
	virtual	void		SetAccessBits(Gen_AccessBits *bits);
	
	OSErr	Dos_IncFileSize(ushort numBytesS);
	OSErr	Dos_GetIndSectorSpec(ushort sectorIndex, Dos_SectorSpec *sectorSpec);
	OSErr	Dos_WriteSector(ushort numBytesS, Dos_Sector *sectorBufP);

	ulong		GetTextFileLength(void);

	Dos_Sector				*GetFirstFileSector(Dos_SectorSpec *firstSectorSpec);
	Dos_FileHeader_BIN		*GetBinFileHeader(Dos_SectorSpec *firstSectorSpec);
	Dos_FileHeader_BASIC	*GetBasFileHeader(Dos_SectorSpec *firstSectorSpec);

	OSErr		GetFileSectors(
		Gen_SectorSpec	*fileSectorsA0, 
		ushort			*numFileSectorsSP, 
		Gen_SectorSpec	*extentSectorsA0, 
		ushort			*numExtentSectorsSP);

	virtual	OSErr		GetEntryAlloc(
		Boolean				getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	#define				GetDosFileType()	(Dos_FileType)GetFileType()

	virtual	void		FlushEntry(void);
	virtual	void		SetFileType_ProEquiv(Byte proType);
	virtual	ushort		GetFileType_ProEquiv(void);
	
	virtual	void		SetFileType(Byte fileType);
	virtual	ushort		GetFileType(void);

	virtual	void		SetFileAndAuxType(Byte fileType, ushort auxType);

	virtual	long		GetFirstBufOffset(void);
	virtual	char		*GetStorageStr(char *buf256);

	virtual	Boolean		IsDeleted(void);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	/***************************************************/
	private:
	ushort				i_cachedLoadAddress;	//	used when creating a file, before it's written

	Dos_DirEntry		i_myEntry;

	//	used during writing basic or bin file
	Dos_SectorSpec		i_curSectorSpec;
	Dos_Sector			*i_curSectorP;
	
	Dos_SectorSpec		i_cached_spec0;
	Dos_SectorSpec		i_cached_spec1;

	typedef CFile _inherited;
};


#endif